;coded by UEZ / Eukalyptus build 2016-01-20
#pragma compile(Icon, "c:\Program Files (x86)\AutoIt3\Icons\au3.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /rm ;/pe
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>


_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $iShowFPS = 0, $bExit
Global Const $iW = 1000, $iH = 600, $sTitle = "GDI+ Simple Flame Sim. v1.1.1", $iW2 = $iW / 2
AutoItSetOption("GUIOnEventMode", 1)

_Init_GDIPlusEx()
GDIPlus_Flame()

_GDIPlus_Shutdown()


Func GDIPlus_Flame($iFlameParticles = 250)
	$bExit = False
	$hGUI = GUICreate($sTitle, $iW, $iH)
	GUISetBkColor(0)
	GUISetState(@SW_SHOW, $hGUI)
;~ 	GUISetCursor(16, 1)

	;create canvas elements
	Local $oBuffer = _GDIPlusEx_BufferCreate($hGUI)
	_GDIPlus_GraphicsSetSmoothingMode($oBuffer.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBuffer.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hBrush_FPS = _GDIPlus_BrushCreateSolid(0xF0FFFFFF), _
				$hFormat_FPS = _GDIPlus_StringFormatCreate(), _
				$hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), _
				$hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), _
				$tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 120, 32)
				$hBrush_FlameParticle = _GDIPlus_BrushCreateSolid(0)

	Local $i, $iFlameParticlesDrawn = 0, $aFlameCoords[$iFlameParticles][8]

	For $i = 0 To $iFlameParticles - 1
		GenFlameParticle($aFlameCoords, $i)
	Next

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)

	Local Const $hFX_BC = _GDIPlus_EffectCreateBrightnessContrast(30, 85), $iBlur = 20
	Local $oBmp_Bg = _GDIPlusEx_BitmapCreateFromMemory(_BG_Pic())
	Local $oBitmap = _GDIPlusEx_BitmapCreate($iW, $iH)
	_GDIPlus_GraphicsSetSmoothingMode($oBitmap.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBitmap.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Do
		_GDIPlusEx_BitmapDraw($oBitmap, $oBmp_Bg, -20)

		For $i = 0 To $iFlameParticles - 1
			DllCall($__g_hGDIPDll, "int", "GdipSetSolidFillColor", "handle", $hBrush_FlameParticle, "dword", $aFlameCoords[$i][6])
			If $aFlameCoords[$i][1] > -$aFlameCoords[$i][4] Then
				DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $oBitmap.Gfx, "handle", $hBrush_FlameParticle, "float", $aFlameCoords[$i][0], "float", $aFlameCoords[$i][1], "float", $aFlameCoords[$i][4], "float", $aFlameCoords[$i][4])
				$iFlameParticlesDrawn += 1
			EndIf
			$aFlameCoords[$i][0] -= $aFlameCoords[$i][2]
			$aFlameCoords[$i][1] -= $aFlameCoords[$i][3]
			$aFlameCoords[$i][4] -= $aFlameCoords[$i][7]
			If $aFlameCoords[$i][4] < $aFlameCoords[$i][7] Then GenFlameParticle($aFlameCoords, $i)
		Next

		_GDIPlusEx_EffectBlurBitmap($oBitmap, $iBlur)
		DllCall($__g_hGDIPDll, "int", "GdipBitmapApplyEffect", "handle", $oBitmap.Bmp, "handle", $hFX_BC, "struct*", Null, "int", 0, "ptr*", 0, "int*", 0)

		$oBitmap.Draw($oBuffer, 0, 0)

		_GDIPlus_GraphicsDrawStringEx($oBuffer.Gfx, "#Flame: " & $iFlameParticlesDrawn & @CRLF & "FPS: " & $iShowFPS, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS) ;draw background message text

		$iFlameParticlesDrawn = 0

		$oBuffer.Draw(0, 0, 0x00CC0020)

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	_GDIPlus_EffectDispose($hFX_BC)
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_BrushDispose($hBrush_FPS)
	_GDIPlus_BrushDispose($hBrush_FlameParticle)
	$oBmp_Bg = Null
	$oBuffer = Null
	$oBitmap = Null
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Flame

Func GenFlameParticle(ByRef $aFlameCoords, $iPos, $iWidth = 200)
	$aFlameCoords[$iPos][4] = Random(75, 150) ;size
	$aFlameCoords[$iPos][0] = Random($iW2 - $iWidth, $iW2 + $iWidth - $aFlameCoords[$iPos][4])
	$aFlameCoords[$iPos][1] = $iH
	$aFlameCoords[$iPos][2] = Random(-5, 5) ;vx
	$aFlameCoords[$iPos][3] = Random(10, 30) ;vy -> flame power
	$aFlameCoords[$iPos][5] = Random(0x80, 0xFF, 1) ;red color value
	Local $iYellow = Int($aFlameCoords[$iPos][5] - 0xFF * Abs($aFlameCoords[$iPos][0] - $iW2) / (1.5 * $iW2))
	$aFlameCoords[$iPos][6] = 0x48FF0000 + 0x100 * $iYellow + Int($iYellow * 0.75)
	$aFlameCoords[$iPos][7] = Random(3.5, 5)
EndFunc

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS
	$iFPS = 0
EndFunc   ;==>CalcFPS

Func _Init_GDIPlusEx()
	Global Const $_cGDIPEX_ISBMP = 0x41455047
	Global Const $_cGDIPEX_ISBUF = 0x42455047
	Global Const $_sGDIPEX_IIDBMP = "{EB22CE37-EE56-458B-AD13-3FC836E8CE49}"
	Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
	Global Const $_tagGDIPEX_BUFFER = "Draw int(int;int;uint); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
	Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
	Global $_aGDIPEX_ASMSTRUCT[1]
	OnAutoItExitRegister("__GDIPlusEx_OnExit")
	Global Const $_hGDIPEX_GDIPDLL = _GDIPlus_Startup()
	Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
	Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
	Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
	Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
	Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
	Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
	Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
	Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
	Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
	Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
	Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
	Global Const $_pGDIPEX_LIB_BMPDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDisposeImage")
	Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
	Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBMP = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B0400752A8B432C8B532052FFD08B43308B532452FFD08B43288B531C52FFD08B432853FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075314883EC20488B4348488B4B30FFD0488B4350488B4B38FFD0488B4340488B4B28FFD0488B43404889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x5356578B5C24108B7424148B7C2418B8FFFFFFFF817B0847504542752E8B4C241C5183EC08C7042400000000C7442404000000008B5328528B5310528B530C5257568B5324528B434CFFD05F5E5BC21000", "0x534889CB4989D24D89C348C7C0FFFFFFFF81790C47504542754B4883EC484C894C244048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B104D89D84C89D2488B4B38488B8388000000FFD04883C4485BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPBMP = __GDIPlusEx_ASMCreate("0x8B5424048B4224C20400", "0x488B4138C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPGFX = __GDIPlusEx_ASMCreate("0x8B5424048B4220C20400", "0x488B4130C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPSCAN0 = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_BMPDRAW = __GDIPlusEx_ASMCreate("0x5756538B7424108B7C2414817F0847504542740E817F08475045417405E98E010000F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C289542410B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED8B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C248A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C60483C70483E9010F8F63FFFFFF83EB010F8F3FFFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554883EC20F30F7F3424F30F7F7C24104889CE4889D7817F0C47504542740E817F0C475045417405E99D010000F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFFF660F6FF0F30F7E6F10660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F4B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED4489CB4C89D74D01DA4C89E64D01EC4489C18A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C6044883C70483E9010F8F61FFFFFF83EB010F8F49FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF30F6F7C2410F30F6F34244883C420415D415C5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPDRAWRECT = __GDIPlusEx_ASMCreate("0x575653558B7424148B7C2418817F0847504542740E817F08475045417405E9DA010000F30F6F44241CF30F7E560CF30F7E5F0C0F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F858C0100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD283EC20660FD60424660FD64C2408660F7ED1660F73DA04660F7ED38B4714894424140FAFC38D04888B571889D501C2895424108B4424140FAF471001C58B46148944241C8B761889742418B800000047660F6EF8660F70FF00B801000000F30F2AF08B0C24F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1013B4C24087CE0660F70EDE18B5C24048B7C24108B44241401442410F30F2AC3F30F59C5F30F2CC08B7424180FAF44241C01C68B0C248B548D008A4416033C000F8488000000660F6E04163CFF747B660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10D0F30F58D1F30F53E2660F70D9000F59CB660F70D8000F59C3660F70E4000F58C10F59C4F30F10C20F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C70483C1013B4C24080F8C58FFFFFF83C3013B5C240C0F8C25FFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5D5B5E5FC21800", "0x660F6E4C2428660F6E442430660F62C85756535541544155415641574883EC30F30F7F3424F30F7F7C2410F3440F7F4424204889D74889CE817F0C47504542740E817F0C475045417405E9FA01000066410F6EC066410F6ED1660F73FA04660FEBC2660F73F908660FEBC1F30F7E5610F30F7E5F100F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F85940100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD266490F7EC04D89C149C1E92066490F7ECA4D89D349C1EB20660F7ED1660F73DA04660F7ED34831C08B47184989C50FAFC3678D04884C8B67204C89E54901C44C89E80FAF47144801C58B46184989C74C8B7620B800000047660F6EF8660F70FF00B801000000F30F2AF04831C94489C1F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1014439D17CE14831D2660F70EDE14489CB4C89E74D01ECF30F2AC3F30F59C5F3480F2CC04C89F6410FAFC74801C64489C18B548D008A4416033C000F848C000000660F6E04163CFF747F660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF3440F10C0F3440F58C1F3410F53E0660F70D900660F70D0000F59CB0F59C2660F70E4000F58C10F59C4F3410F10C00F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C70483C1014439D10F8C54FFFFFF83C3014439DB0F8C28FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF3440F6F442420F30F6F7C2410F30F6F34244883C430415F415E415D415C5D5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPCLR = __GDIPlusEx_ASMCreate("0x8B542404660F6E442408660F70C0008B4A100FAF4A148B5218660F7F0283C21083E9107FF4C20800", "0x660F6EC2660F70C0008B51140FAF5118488B4920660F7F014883C11083EA107FF3C3")
	Global Const $_pGDIPEX_ASM_FXBLUR = __GDIPlusEx_ASMCreate("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
			"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
EndFunc   ;==>_Init_GDIPlusEx

Func _GDIPlusEx_BitmapClear($oBitmap, $iColor = 0)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "uint", $iColor)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapClear

Func _GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBmp = __GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRABORTED, 2, False)
	Local $oBitmap = __GDIPlusEx_BitmapCreateObject($tBmp)
	If Not IsObj($oBitmap) Then
		__GDIPlusEx_BitmapDispose($tBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreate

Func _GDIPlusEx_BitmapDraw($oBuffer, $oBitmap, $iX = 0, $iY = 0)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 2, False)
	Local $iStatus = $oBitmap.Draw($oBuffer, $iX, $iY)
	If $iStatus Then Return SetError($GDIP_ERRABORTED, 3, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapDraw

Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate

Func _GDIPlusEx_BitmapCreateFromImage($hImage, $iWidth = 0, $iHeight = 0, $hImgAttr = 0, $iInterpolationMode = 6)
	Local $iImgW = _GDIPlus_ImageGetWidth($hImage)
	Local $iImgH = _GDIPlus_ImageGetHeight($hImage)
	If @error Or Not $iImgW Or Not $iImgH Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)

	If $iWidth = 0 Then $iWidth = $iImgW
	If $iHeight = 0 Then $iHeight = $iImgH

	Local $oBitmap = _GDIPlusEx_BitmapCreate($iWidth, $iHeight)
	If @error Then Return SetError(@error, @extended, False)

	Local $iIP = _GDIPlus_GraphicsGetInterpolationMode($oBitmap.Gfx)
	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iInterpolationMode)

	_GDIPlus_GraphicsDrawImageRectRect($oBitmap.Gfx, $hImage, 0, 0, $iImgW, $iImgH, 0, 0, $iWidth, $iHeight, $hImgAttr)

	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iIP)
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreateFromImage

Func _GDIPlusEx_BitmapCreateFromMemory($bImage, $iWidth = 0, $iHeight = 0, $hImgAttr = 0, $iInterpolationMode = 6)
	Local $hImage = _GDIPlus_BitmapCreateFromMemory($bImage)
	If @error Or Not $hImage Then Return SetError(@error, @extended, False)

	Local $tBitmap = _GDIPlusEx_BitmapCreateFromImage($hImage, $iWidth, $iHeight, $hImgAttr, $iInterpolationMode)
	Local $iError = @error, $iExtended = @extended

	_GDIPlus_ImageDispose($hImage)

	Return SetError($iError, $iExtended, $tBitmap)
EndFunc   ;==>_GDIPlusEx_BitmapCreateFromMemory

Func _GDIPlusEx_BufferDraw($oBuffer, $iX = 0, $iY = 0, $iROP = 0x00CC0020)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iStatus = $oBuffer.Draw($iX, $iY, $iROP)
	If Not $iStatus Then Return SetError($GDIP_ERRABORTED, 2, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BufferDraw

Func _GDIPlusEx_EffectBlurBitmap($oBitmap, $iRadius)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	$iRadius = Int($iRadius)
	If $iRadius < 1 Or $iRadius > 127 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tTmp = __GDIPlusEx_BitmapCreate($oBitmap.Width, $oBitmap.Height)
	DllCallAddress("none", $_pGDIPEX_ASM_FXBLUR, "struct*", $tTmp, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "int", $iRadius)
	__GDIPlusEx_BitmapDispose($tTmp)
	Return True
EndFunc   ;==>_GDIPlusEx_EffectBlurBitmap

Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate

Func __GDIPlusEx_BitmapCreate($iW, $iH, $iColor = 0)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	If $iColor Then DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", $tBitmap, "uint", $iColor)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate

Func __GDIPlusEx_BitmapCreateObject($tBmp)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; handle Gfx; handle Bmp; ptr pGlobalFree; ptr pGfxDel; ptr pBmpDel; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pGetBmp; ptr pGetGfx; ptr pGetScan0; ptr pGetW; ptr pGetH; ptr pGetStride; ptr pDraw; ptr pDrawRect; endstruct;", DllStructGetPtr($tBmp))
	Local $hBmp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tBmp, "Width"), DllStructGetData($tBmp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tBmp, "Stride"), DllStructGetData($tBmp, "pScan0"))
	Local $hGfx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	DllStructSetData($tBitmap, "Bmp", $hBmp)
	DllStructSetData($tBitmap, "Gfx", $hGfx)
	DllStructSetData($tBitmap, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBitmap, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBitmap, "pBmpDel", $_pGDIPEX_LIB_BMPDEL)
	DllStructSetData($tBitmap, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBitmap, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBitmap, "pRelease", $_pGDIPEX_ASM_OBJ_RELBMP)
	DllStructSetData($tBitmap, "pGetBmp", $_pGDIPEX_ASM_OBJ_BMPBMP)
	DllStructSetData($tBitmap, "pGetGfx", $_pGDIPEX_ASM_OBJ_BMPGFX)
	DllStructSetData($tBitmap, "pGetScan0", $_pGDIPEX_ASM_OBJ_BMPSCAN0)
	DllStructSetData($tBitmap, "pGetW", $_pGDIPEX_ASM_OBJ_BMPWIDTH)
	DllStructSetData($tBitmap, "pGetH", $_pGDIPEX_ASM_OBJ_BMPHEIGHT)
	DllStructSetData($tBitmap, "pGetStride", $_pGDIPEX_ASM_OBJ_BMPSTRIDE)
	DllStructSetData($tBitmap, "pDraw", $_pGDIPEX_ASM_BMPDRAW)
	DllStructSetData($tBitmap, "pDrawRect", $_pGDIPEX_ASM_BMPDRAWRECT)
	DllStructSetData($tBitmap, "Vtbl", DllStructGetPtr($tBitmap, "pQueryInterface"))
	DllStructSetData($tBitmap, "RefCnt", 1)
	Local $oBitmap = ObjCreateInterface(DllStructGetPtr($tBmp), $_sGDIPEX_IIDBMP, $_tagGDIPEX_BITMAP)
	If Not IsObj($oBitmap) Then
		_GDIPlus_GraphicsDispose($hGfx)
		_GDIPlus_BitmapDispose($hBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreateObject

Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose

Func __GDIPlusEx_ObjGetPtr($oObj)
	If Not IsObj($oObj) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, 0)
	Local $pPtr
	$oObj.QueryInterface("", $pPtr)
	$oObj.Release
	Return $pPtr
EndFunc   ;==>__GDIPlusEx_ObjGetPtr

Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-09-19

Func _BG_Pic($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $BG_Pic
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= 'Ghwbti9v8IaZaE3HFVRDVEbvSmW06YJOIlPNvMOEWLpKqiexI6kMrUbxgHdugwpBvGIFDRC6O5bWTLYYdo7oktsyP8HX4VeGSjJan8TBSDkpxbOUfNUbNMFtHJMDBp+fUhVGWeDpAl/dogPc9OQ5t14oQo5CoHhOjpmpI4SWkfwZqit87OOoQ3Q2MkJTVAgk4iUDTD9MHNGCY7+pIIMiIbpCs10YN7sVrhSFXjEmINGetMpWwqQ83cM0HV2fwQACZNwhVIfl5S6JqOrshSp2YoA5V/JHYnSYTRWjwNGydqtPUosOngH8k9h1wZ8szYr1k6DipcSYKTaqW6FsOjKFx1j+BjwlS05A5NJ/OMA0cgYuUZNptUdQhymEVXXMhlGoQZmZ6lpcvpLGStPTTAUi1pdqTigE8GbxHlDEsIBOYhTbiaqx/AUvPJlRUW26Y8ko0hZKyJm/ElGAnYnKeV8oyeRbyUD59TEOp0WKTrEWK83eykq6KoKFCRGKGnTNsx5ZRJTvMoKFpkofb0lQq0cWkwKLRrFSgrWZk4odlN1VjafnHkbauFXa4rqcaM8eBcunoMVDa+gZJ6ae/GDLxm1HllBFbSUJ/MRVWPf9tClpqMpvJjyWiSrwVrMycUuOWNIv7eyFUl3lDYhGrshS1ma1Wk9Tw0tUnkWoXBdSJOp5RA/MdmMELNZrVBpNDKQ+b06FdxhaHEEFN6SLR9qkBMwmk0rg2NevZ3x5JQQEgWZMFSzMnFvqoFqlHQIrng6O3mg/me2Cs2J5o1DqgCDIi4wlaTVpCL+2C80JSz2+j+mMFIVZqgIek3SAMlQvEFRTWa0OpGSduqJES+zpbbbUVG4AWwKR4RKSsW4LR79cFmj5DcTNpxao95OiMGiyjptKjz+3ZFVHIpu7e3qkFpMlCA42arqc5P8A3RBdZEpZ7fR/TGrIVIxgKaMIg2TMF/wW4lBNuCOYe6MG80plWpdx2GJESPb9jEkynrgO0rzVrWvP3aILNCQFOaVaTtMEuLMtWNIWAXqNwjBNWMC1Sjz+09kYJs8ENPS6qBaTJQgLbODfToibYqPaWtfaMcKacIjAeEWUrSdYgueDKSEz/dLyk/pHD0daE9NOUiLBW9m3jskVtkBDaS4rotisYDlKKaIjtyl/pHAJD1I+8Nqt8FKTUb1CJkzxitRqNC9RiqngqOm23T2mMG3Y1/y6rAgyIuIgBRwb+g64qv8ABvfeaDtgpWJHHBbcIipSkB1MTUgUZ085OTFah0xFIT0Xh84y6EsjpMmtElhTZ1OIIjmnYoRyat0Zp3Rd8IuO6MxW6LU1fasjOT7rfyjgaK+5sRVG+Ju4KjJ9c1zE6bSjSVDmkyG4Rg/B9GSkdglGU4QnUItM8cOP2TtS2M5UYR4hplOakXDZFUZDQuT39WQh+0aHNIgIcGGo5ulo2H5RhGVYVvTrG3iLDKODeUPfGWQ4O2JUmiJVHCUNCD2JixWD2KMZHhBxOxyP/KO/5It8Jun/ANscJSFObVxYwHNtsebUJA2JAiTLSURlPKlGUoniJIE4k1J57p80bNcFb6sI8ebO33xWWdg0Dq3k2pN6DdFejLKHRzNP6xJ0YB3pgZJ2jRAmMk3KFx4u+M4xnGM4xfxcgJx5wrK+6Tne/VBFjFHGjR79cFNG/wAp+UEzmdfV6q+MIOkM6CqjuB1s3p7xFvmy96f0iZE0m5SbQfs0kiZ7I84cqn7tNqv0irRkYFPSGdvi/DuahcIy1WaEi7rCFJUUq1iJPoreui+CqivT1p7xEn2aiuk33RwLiXfVuVuiSklJ7fsNZQDaOksyEXqfV6uSIIQAw3pq5Pxi/Dr7LokTVR0EXdZpLk8n1++Lyye20RwbuFb1TrDdHC0aR1oNXvix1SP6ie6MhbbmxYnujKaUNo4ixJOwRlJwf9Q1fzjLpCNiMqMlC3T6xqxwTaWR6ifnfFakUia+w1jHAtW9JyOEWVdmjrVMGWyLV4QeuJxwjH4DFjik'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= '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'
	$BG_Pic &= 'YjNYitQ7TAAAOXEKkMut57J7BvHmGDM+22nceI0BmR1pMroY6RqBOFw7EKuW41RY805kYJlDqmxFB5xwzk0W3d12AK07jS3eBsb6zIqLDmXtYn8MIfdERmWTdGFrfyhNx4lrgnKtVgb5dtlXcX9xzGGTsxbtHUzESA1H01qJEljDTLmwuxSdoLc6E/W2j1KZZuh5g7D/AHPWW3pVjrsnYzBAHKmBy6HkjKARqbkY6OailwpD/wDESFsCIVhP+IywzUO60rmWY5rmo6uh5jTbAdr+HywyfLvs3P2TrKzQ8nCvsEaamhEE6x+otqrmL0ccX0Kmf/GFZTYZfE1l6EKN8w20ODq5hv8AVvj9gCXEuiInMRay6Lf8No3muuWDMdGiFYolSGiQoQS47IDj/qOpK0xuwdNquW+52EeCrOTkmGZ30csx6Syuw8kcvuwcj6gUmR158zcW19fK8nkmmRqG91+0cerjvs7B3YdJtIb3oEtg60UXhR+IXITkY+Ll34Afidv3/oiNUz0/qnwff1yqLnkb4I1tmi59k+8MBro48te00KeqfDJ0epqI40PeDt5QjwZfNzRVstB2IzbM2rhvoYvRt5l9Br2l2qCBwtc+rxrQipWTSCgPcNi3l6AUuIticv5HptLoNfMsay91i2/w9VLWsRaxkZmmOXO8KwSssNg/Jsdqm++zSd9jm2Nas3B1UFWF01a66NNKRTX1XDMM2vQuTHKqbVSCkN1wK0+dYMA1WI9gxdv2hPLhW5cmC8NwGz9qFe82thHD/XLR4l/RCJl5/TQMcBl818OK+wVvmaZKCXHvKNvNwPBG7dbyS7Ln0tGYtJ0PVb5SHQC1U4AN2Yj+9Fj3nGo1eH9hs7R07FFxjnlYYcfk38xrZjpzG3S/eOv8RXvOdF3R2Q2oPMZd53f73UheMwgTc2JuZOSWEgYVLVsZMa2y0iqVaZzQ2J2YtuIpE4mSNElToekrFHGHmGiDspgg+cD2vOOoXu4v7kpWoXu+kvpsxJpRIvouqVQNr4ligLEFNWW0dOVNigly8imopnEa4vQQsEqiZ7dDu9KjIxtNpyx0wycxVrLu0W/4mQgxUZjIzEpoipHqBSdmXd6Ag7v6esyoIYffDalJswxwrqWbo03dQG8bV7BQ1bQ+88kz6THLPVej6o9M7IekJ6M6U6fp56qdH0FA1SCWWaB1E7FgeUeCBkouoGLXCnaKu1h/CEPmPi+81kbQp408IliGTmNbMuiRb/io1KIpvF3REZjU2TTJg0PbWVyEqoPvofFXK1qqwNRrArwo6xM0wGN6os7A4ldhil4RSrxdY6PqXofM6FRzadKdH0OhO2dk7YU2nRlO0xaR3adDzKgC10rLNYwDLoIW9C2daEO9nv4z5i8zKBlFI7U8NOhAK0Cr6otc8D3iHpULu6rO8xIgDQNoidUVax3eXxy/jA1DKIMcrMVGY9MxSvjKAE6JQ8kRmhsnsKfe5Uk7kXtD8R+W6HZRHgDE6HVbl5AnYiivaulbcC37oQecwc8k+MGsN0RD5qI0i6kcNJY1Kn6xOyHROjcMKDVIviN9pkH90RNQ6zN2glybsDHrfTwgoqdtCDfCeBMnxGO/s57pCQwxd2kO/RWVMzS3YBwEvuqRbZMW+Y26PCMW/wCN3U6kUjboxvFBbFKhBIIiLdp+5NI6WB2N3zElX4G061a/eV5ba3I8kK1katPzDmkapnxM96CN+QMPvJD2YjrdMr3sX7uLD08F8Y9o2ryX3iBjwoFcW/GWYVhY3kK+YdnukD5fsgwaaXsddHxC6B5EuyFEIIgdIrDJ1RFcxbZiLrLd42f4/co3iEU3jiZjm8c3RDlFIUNfvKnDuJaHvh9kbALRw/mDYVY1wHf/AH0iKsL+towWMJ+FHXzY/McrSeUz6ZW84zuiu6KwlsxXeOouKv8AkdwUKSjeIbxTeMQpDm6OQlQPlBG7Fcou9URhm8ozvGbhXeO7xHeW7xm3+U3BwQwXMFzB'
	$BG_Pic &= 'G8HWssbzrS3MvzFXrE5i3eKYuKZf8yuXLly5f/8AK3//2Q=='
	Local $bString = _WinAPI_Base64Decode($BG_Pic)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Au3.jpg", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_BG_Pic

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode